/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.shockcalculation;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.OpType;
import moe.score.pishockzap.shockcalculation.CalculatedShock;

public class ShockQueue {
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    private final BlockingQueue<QueuedShock> queue = new LinkedBlockingQueue<QueuedShock>();
    @NonNull
    private final PishockZapConfig config;

    @NonNull
    public CalculatedShock takeAndMergeShocks() throws InterruptedException {
        QueuedShock nextShock;
        QueuedShock shock = this.queue.take();
        while ((nextShock = (QueuedShock)this.queue.peek()) != null && this.mergeShock(shock, nextShock)) {
            this.queue.remove();
        }
        return this.transformShock(shock);
    }

    boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private boolean mergeShock(@NonNull QueuedShock shock, @NonNull QueuedShock nextShock) {
        float damageEquivalent;
        float duration;
        Objects.requireNonNull(shock, "shock is marked non-null but is null");
        Objects.requireNonNull(nextShock, "nextShock is marked non-null but is null");
        if ((nextShock.isDeath || shock.isDeath) && this.config.isShockOnDeath()) {
            return false;
        }
        if (nextShock.distribution != shock.distribution) {
            return false;
        }
        if (this.config.isQueueDifferent() && nextShock.damageEquivalent != shock.damageEquivalent) {
            return false;
        }
        if (this.config.isAccumulateDuration()) {
            duration = shock.duration * shock.damageEquivalent + nextShock.duration * nextShock.damageEquivalent;
            if ((duration /= Math.max(shock.damageEquivalent, nextShock.damageEquivalent)) < 0.0f || duration > 15.0f) {
                return false;
            }
        } else {
            duration = Math.max(shock.duration, nextShock.duration);
        }
        if (this.config.isAccumulateIntensity() && !this.config.isQueueDifferent() && !this.config.isShockOnHealth()) {
            damageEquivalent = shock.damageEquivalent + nextShock.damageEquivalent;
            if (damageEquivalent < 0.0f || damageEquivalent > 1.0f) {
                return false;
            }
        } else {
            damageEquivalent = Math.max(shock.damageEquivalent, nextShock.damageEquivalent);
        }
        shock.duration = duration;
        shock.damageEquivalent = damageEquivalent;
        return true;
    }

    @NonNull
    private CalculatedShock transformShock(@NonNull QueuedShock shock) {
        float duration;
        int intensity;
        OpType type;
        boolean separateDeathShock;
        Objects.requireNonNull(shock, "shock is marked non-null but is null");
        boolean bl = separateDeathShock = this.config.isShockOnDeath() && shock.isDeath;
        if (shock.damageEquivalent > 1.0f) {
            this.logger.warning("Damage equivalent is greater than max damage, clamping to max damage");
            shock.damageEquivalent = 1.0f;
        }
        if (separateDeathShock) {
            type = this.config.isVibrationOnly() ? OpType.VIBRATE : OpType.SHOCK;
            intensity = this.config.getShockIntensityDeath();
            duration = this.config.getShockDurationDeath();
        } else {
            float vibrationThreshold = this.config.getVibrationThreshold();
            float minDamage = this.config.getMinDamage();
            if (this.config.isVibrationOnly()) {
                vibrationThreshold = 1.0f;
            }
            if (shock.damageEquivalent > vibrationThreshold) {
                type = OpType.SHOCK;
                intensity = this.transformIntensityIntoRange(shock.damageEquivalent - vibrationThreshold - minDamage, this.config.getMaxDamage() - vibrationThreshold - minDamage, this.config.getShockIntensityMin(), this.config.getShockIntensityMax());
            } else {
                type = OpType.VIBRATE;
                intensity = this.transformIntensityIntoRange(shock.damageEquivalent - minDamage, Math.min(vibrationThreshold, this.config.getMaxDamage()) - minDamage, this.config.getVibrationIntensityMin(), this.config.getVibrationIntensityMax());
            }
            duration = shock.duration;
            intensity = this.sanityCheckIntensity(type, intensity);
            duration = this.sanityCheckDuration(duration);
        }
        return new CalculatedShock(shock.distribution, type, intensity, duration);
    }

    private float sanityCheckDuration(float duration) {
        if (duration < 0.0f || duration > 15.0f) {
            this.logger.warning("Duration out of range: " + duration);
            duration = Math.max(0.0f, Math.min(duration, 15.0f));
        }
        if (duration < this.config.getDuration() || duration > this.config.getMaxDuration()) {
            this.logger.warning("Duration out of configured range: " + duration);
            duration = Math.max(this.config.getDuration(), Math.min(duration, this.config.getMaxDuration()));
        }
        return duration;
    }

    private int sanityCheckIntensity(@NonNull OpType type, int intensity) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        if (intensity < 0 || intensity > 100) {
            this.logger.warning("Intensity out of range: " + intensity);
            intensity = Math.max(0, Math.min(intensity, 100));
        }
        if (type == OpType.SHOCK && (intensity < this.config.getShockIntensityMin() || intensity > this.config.getShockIntensityMax())) {
            this.logger.warning("Shock intensity out of range: " + intensity);
            intensity = Math.max(this.config.getShockIntensityMin(), Math.min(intensity, this.config.getShockIntensityMax()));
        }
        if (type == OpType.VIBRATE && (intensity < this.config.getVibrationIntensityMin() || intensity > this.config.getVibrationIntensityMax())) {
            this.logger.warning("Vibration intensity out of range: " + intensity);
            intensity = Math.max(this.config.getVibrationIntensityMin(), Math.min(intensity, this.config.getVibrationIntensityMax()));
        }
        return intensity;
    }

    private int transformIntensityIntoRange(float damageEquivalent, float damageRange, int intensityMin, int intensityMax) {
        if (damageRange <= 0.0f) {
            return intensityMax;
        }
        if (damageEquivalent <= 0.0f) {
            return intensityMin;
        }
        if (damageEquivalent >= damageRange) {
            return intensityMax;
        }
        return Math.round(damageEquivalent / damageRange * (float)(intensityMax - intensityMin) + (float)intensityMin);
    }

    public void queueShock(@NonNull ShockDistribution distribution, boolean isDeath, float damageEquivalent) {
        Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
        this.queue.add(new QueuedShock(distribution, isDeath, damageEquivalent, this.config.getDuration()));
    }

    public ShockQueue(@NonNull PishockZapConfig config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        this.config = config;
    }

    private static final class QueuedShock {
        @NonNull
        private final ShockDistribution distribution;
        private final boolean isDeath;
        private float damageEquivalent;
        private float duration;

        public QueuedShock(@NonNull ShockDistribution distribution, boolean isDeath, float damageEquivalent, float duration) {
            Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
            this.distribution = distribution;
            this.isDeath = isDeath;
            this.damageEquivalent = damageEquivalent;
            this.duration = duration;
        }
    }
}

